# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Apply master page settings to a SharePoint site
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# Relative URL to the System Master Page
$systemMasterUrl = "/_catalogs/masterpages/seattle.master"

# Relative URL to the Site Master Page
$customMasterUrl = "/_catalogs/masterpages/seattle.master"

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site
$web = Get-SPWeb $webUrl

# Set the System Master Page
$web.MasterUrl = $systemMasterUrl

# Set the Site Master Page
$web.CustomMasterUrl = $customMasterUrl

# Update the site
$web.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 